#include <iostream>
#include <fstream>
#include <vector>
#include <set>
#include <string>
#include <map>
#include <cstdlib>
#include <cstdio>
#include <ctime>
#include <cmath>
#include <algorithm>
using namespace std;

#define forn(i, n) for(int i = 0; i < (int)n; ++i)
#define all(a) a.begin(), a.end()

#define mp make_pair
#define pb push_back

#define fs first
#define sc second

const long double EPS = 1e-9;

struct Point {
    long double x, y;

    Point() {}

    Point(long double x, long double y): x(x), y(y) {}

    Point operator*(long double p) const {
        return Point(x * p, y * p);
    }

    Point operator/(long double p) const {
        return Point(x / p, y / p);
    }

    Point operator+(const Point &p) const {
        return Point(x + p.x, y + p.y);
    }

    Point operator-(const Point &p) const {
        return Point(x - p.x, y - p.y);
    }
};

struct Line {
    long double a, b, c;

    Line() {}

    Line(long double a, long double b, long double c): a(a), b(b), c(c) {}

    Line(const Point &aa, const Point &bb): a(bb.y - aa.y), b(aa.x - bb.x), c(-(aa.x * a + aa.y * b)) {}
};

Point intersect(const Line &a,const Line &b) {
    long double det = a.a * b.b - a.b * b.a;
    return Point((-a.c * b.b - a.b * (-b.c)) / det, (a.a * (-b.c) - (-a.c) * b.a) / det);
}

long double len(const Point &p) {
    return sqrt(p.x * p.x + p.y * p.y);
}

long double dist(const Point &p, const Line &l) {
    return fabs(l.a * p.x + l.b * p.y + l.c) / sqrt(l.a * l.a + l.b * l.b);
}

bool onLine(const Point &p, const Line &l) {
    return dist(p, l) < EPS;
}

Point symm(const Point &p, const Line &l) {
    Point ort(l.a, l.b);
    ort = ort * (dist(p, l) / len(ort));
    if(onLine(p + ort, l))
        return p + ort + ort;
    return p - ort - ort;
}

struct Obj {
    bool b;
    Point p;
    Line l;

    Obj() {}

    Obj(int x, int y): b(true), p(Point(x, y)) {}

    Obj(const Point &p): b(true), p(p) {}

    Obj(const Line &l): b(false), l(l) {}

    Obj operator+(const Obj &obj) const {
        if(b && obj.b)
            return Obj(Line(p, obj.p));
        if(!b && !obj.b)
            return Obj(intersect(l, obj.l));
        if(b)
            return Obj(symm(p, obj.l));
        return Obj(symm(obj.p, l));
    }
};

int readNum(const string &s, size_t &i) {
    bool neg = s[i] == '-';
    if(neg)
        i++;
    int res = 0;
    while(i < s.length() && '0' <= s[i] && s[i] <= '9') {
        res = res * 10 + s[i] - '0';
        i++;
    }
    return res * (neg? -1 : 1);
}

Obj readPoint(const string &s, size_t &i) {
    int x = readNum(s, i);
    i++;
    int y = readNum(s, i);
    i++;
    return Obj(x, y);
}

Obj process(const string &s, size_t &i) {
    i++;
    Obj l;
    if(s[i] == '(')
        l = process(s, i);
    else
        l = readPoint(s, i);
    while(i < s.length() && s[i] != ')') {
        i += 2;
        Obj r;
        if(s[i] == '(')
            r = process(s, i);
        else
            r = readPoint(s, i);
        l = l + r;
    }
    i++;
    return l;
}

int main()
{
    ios_base::sync_with_stdio(0);
    cout.setf(ios::fixed);
    cout.precision(10);
    while(true) {
        string s;
        cin >> s;
        if(s == "#")
            break;
        size_t pos = 0;
        Obj obj = process(s, pos);
        cout << obj.p.x << ' ' << obj.p.y << '\n';
    }
    return 0;
}
